package org.beast.security.core;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.experimental.Tolerate;

/**
 * SNS下的身份信息
 */
@Builder
@Data
public class SNSIdentity {

    private SNSType type;

    private String appid;

    private String openid;


    @Tolerate
    public SNSIdentity() {
    }

    public SNSIdentity valueOf(SNSUserToken userToken) {
        var type = userToken.getType();
        if (userToken instanceof WechatWeappSNSUserToken weappSNSUserToken) {
            return SNSIdentity.builder()
                    .type(SNSType.WECHAT_WEAPP)
                    .appid(weappSNSUserToken.getAppid())
                    .openid(weappSNSUserToken.getOpenid())
                    .build();
        } else if (userToken instanceof WechatOffiAccountSNSUserToken offiAccountSNSUserToken) {
            return SNSIdentity.builder()
                    .type(SNSType.WECHAT_OFFIACCOUNT)
                    .appid(offiAccountSNSUserToken.getAppid())
                    .openid(offiAccountSNSUserToken.getOpenid())
                    .build();
        } else if (userToken instanceof BytedanceByteappSNSUserToken byteappSNSUserToken) {
            return SNSIdentity.builder()
                    .type(SNSType.BYTEDANCE_BYTEAPP)
                    .appid(byteappSNSUserToken.getAppid())
                    .openid(byteappSNSUserToken.getOpenid())
                    .build();
        }
        throw new UnsupportedOperationException(
                String.format("type: [%s] unable support", type)
        );
    }
}
