package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.beast.security.core.exception.TokenExpiredException;

import java.time.Instant;

/**
 * 匿名Token
 */
@ToString
@Getter @Setter
public class AnonymousToken implements TokenNamed {
    private static final String NAME = "AnonymousToken";

    /**
     * 生成的唯一匿名ID
     */
    private String anonymousId;


    //发行时间
    private Instant issuedAt;

    //于过期
    private Instant expiresAt;

    @Override
    public String name() {
        return NAME;
    }


    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }
    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        };
    }
}
