/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.codec;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;
import org.beast.security.core.EmailToken;
import org.beast.security.core.codec.AbstractJWTTokenBuilder;
import org.beast.security.core.codec.AbstractJWTTokenParser;
import org.beast.security.core.codec.TokenCodec;
import org.beast.security.core.util.KeySpecUtils;

public class EmailTokenCodec
implements TokenCodec<EmailToken> {
    private static final String PRI_RESOURCE = "classpath:token/email-token-private.der";
    private static final String PUB_RESOURCE = "classpath:token/email-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    @Override
    public String encode(EmailToken token) {
        return TokenBuilder.getInstance().compact(token);
    }

    @Override
    public EmailToken decode(String tokenString) {
        return (EmailToken)TokenParser.getInstance().parse(tokenString);
    }

    public static class TokenBuilder
    extends AbstractJWTTokenBuilder<EmailToken> {
        private static final TokenBuilder INSTANCE = new TokenBuilder();

        public TokenBuilder() {
            this(KeySpecUtils.readPrivateKey(EmailTokenCodec.PRI_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public TokenBuilder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, EmailToken token) {
            claims.put("email", token.getEmail());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }

        public static TokenBuilder getInstance() {
            return INSTANCE;
        }
    }

    public static class TokenParser
    extends AbstractJWTTokenParser<EmailToken> {
        private static final TokenParser INSTANCE = new TokenParser();

        public TokenParser() {
            this(KeySpecUtils.readPublicKey(EmailTokenCodec.PUB_RESOURCE));
        }

        public TokenParser(Key key) {
            super(key);
        }

        @Override
        protected EmailToken read(Claims claims) {
            EmailToken token = new EmailToken();
            token.setEmail((String)claims.get("email", String.class));
            token.setIssuedAt(Instant.ofEpochMilli((Long)claims.get("iss", Long.class)));
            token.setExpiresAt(Instant.ofEpochMilli((Long)claims.get("exp", Long.class)));
            token.verify();
            return token;
        }

        public static TokenParser getInstance() {
            return INSTANCE;
        }
    }

    private static final class CLAIM_NAMES {
        private static final String EMAIL = "email";
        private static final String ISSUED_AT = "iss";
        private static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

