/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.codec;

import com.google.common.collect.Maps;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJWTTokenBuilder<T> {
    private Key key;
    private SignatureAlgorithm algorithm;

    public AbstractJWTTokenBuilder(Key key, SignatureAlgorithm algorithm) {
        this.key = key;
        this.algorithm = algorithm;
    }

    protected abstract void write(Map<String, Object> var1, T var2);

    public String compact(T token) {
        HashMap claims = Maps.newHashMap();
        this.write(claims, token);
        return Jwts.builder().signWith(this.key, this.algorithm).setClaims((Map)claims).compact();
    }
}

