/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import java.time.Instant;
import org.beast.security.core.TokenNamed;
import org.beast.security.core.exception.TokenExpiredException;

public class AnonymousToken
implements TokenNamed {
    private static final String NAME = "AnonymousToken";
    private String anonymousId;
    private Instant issuedAt;
    private Instant expiresAt;

    @Override
    public String name() {
        return NAME;
    }

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        }
    }

    public String toString() {
        return "AnonymousToken(anonymousId=" + this.getAnonymousId() + ", issuedAt=" + this.getIssuedAt() + ", expiresAt=" + this.getExpiresAt() + ")";
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setAnonymousId(String anonymousId) {
        this.anonymousId = anonymousId;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }
}

