package org.beast.security.core.codec;

import com.google.common.collect.Maps;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

import java.security.Key;
import java.util.Map;

public abstract class AbstractJWTTokenBuilder<T> {
    private Key key;
    private SignatureAlgorithm algorithm;

    public AbstractJWTTokenBuilder(Key key, SignatureAlgorithm algorithm) {
        this.key = key;
        this.algorithm = algorithm;
    }

    protected abstract void write(Map<String, Object> claims, T token);

    public String compact(T token) {
        Map<String, Object> claims = Maps.newHashMap();
        this.write(claims, token);
        return Jwts.builder().signWith(key, algorithm)
                .setClaims(claims)
                .compact();
    }
}
