package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

@Getter @Setter
public class AppOnceToken {

    private String appId;

    //随机数
    private String nonce;

    //发行时间
    private Instant issuedAt;

    public AppOnceToken() {
    }

    public AppOnceToken(String appId, String nonce, Instant issuedAt) {
        this.appId = appId;
        this.nonce = nonce;
        this.issuedAt = issuedAt;
    }

    public boolean isExpireAt(int seconds) {
        Instant validity = this.issuedAt.plusSeconds(seconds);
        return Instant.now().isBefore(validity);
    }
}
