/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.util;

import java.net.URL;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.io.IOUtils;
import org.springframework.util.ResourceUtils;

public class KeySpecUtils {
    public static PrivateKey readPrivateKey(String resource) {
        try {
            URL url = ResourceUtils.getURL((String)resource);
            byte[] keyBytes = IOUtils.toByteArray((URL)url);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static PublicKey readPublicKey(String resource) {
        try {
            URL url = ResourceUtils.getURL((String)resource);
            byte[] keyBytes = IOUtils.toByteArray((URL)url);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

