package org.beast.security.core;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.Nullable;

/**
 * 微信小程序社交平台凭证
 */
@Getter
@Setter
@ToString
public class WechatWeappSNSToken extends SNSToken{


    /**
     * 小程序 用户唯一标识
     */
    private String openid;

    /**
     * 用户在开放平台的唯一标识符,(有条件的获取，不保证)
     */
    private @Nullable String unionId;

    /**
     * 会话密钥
     */
    private String sessionKey;


    public WechatWeappSNSToken() {
        super(SNSTokenType.WECHAT_WEAPP);
    }
}
