package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;

/**
 * 支付宝用户凭据 （写入cookie）
 * wx-token与UserToken是独立的，可以同时存在，且非绑定状态
 */
@Getter
@Setter
public class AlipaySNSUserToken extends SNSUserToken{


    /**
     * 支付宝用户的唯一标识。以2088开头的16位数字。
     */
    private String userId;

    protected AlipaySNSUserToken() {
        super(SNSTokenType.ALIPAY);
    }
}
