package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * https://opendocs.alipay.com/apis/api_9/alipay.system.oauth.token
 */
@ToString
@Getter @Setter
public class AlipaySNSToken extends SNSToken {




    /**
     * 支付宝用户的唯一标识。以2088开头的16位数字。
     */
    private String userId;

    /**
     * 访问令牌。通过该令牌调用需要授权类接口
     */
    private String accessToken;

    public AlipaySNSToken() {
        super(SNSTokenType.ALIPAY);
    }
}
