/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import org.beast.security.core.AlipaySNSUserToken;
import org.beast.security.core.BytedanceByteappSNSUserToken;
import org.beast.security.core.SNSTokenType;
import org.beast.security.core.TokenNamed;
import org.beast.security.core.WechatOffiAccountSNSUserToken;
import org.beast.security.core.WechatWeappSNSUserToken;
import org.beast.security.core.exception.TokenExpiredException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AlipaySNSUserToken.class, name="ALIPAY"), @JsonSubTypes.Type(value=WechatWeappSNSUserToken.class, name="WECHAT_WEAPP"), @JsonSubTypes.Type(value=WechatOffiAccountSNSUserToken.class, name="WECHAT_OFFIACCOUNT"), @JsonSubTypes.Type(value=BytedanceByteappSNSUserToken.class, name="BYTEDANCE_BYTEAPP")})
public class SNSUserToken
implements TokenNamed {
    private static final String NAME = "SNSUserToken";
    private SNSTokenType type;
    private String appid;
    private Instant issuedAt;
    private Instant expiresAt;

    protected SNSUserToken(SNSTokenType type) {
        this.type = type;
    }

    @Override
    public String name() {
        return NAME;
    }

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        }
    }

    public SNSTokenType getType() {
        return this.type;
    }

    public String getAppid() {
        return this.appid;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setType(SNSTokenType type) {
        this.type = type;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }
}

