package org.beast.security.core;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;


/**
 */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = "type",
        visible = true
)
@JsonSubTypes({
        @JsonSubTypes.Type(value = AlipaySNSToken.class, name = "ALIPAY"),
        @JsonSubTypes.Type(value = WechatOPlatformSNSToken.class, name = "WECHAT_OPLATFORM"),
        @JsonSubTypes.Type(value = WechatOffiAccountSNSToken.class, name = "WECHAT_OFFIACCOUNT"),
        @JsonSubTypes.Type(value = WechatWeappSNSToken.class, name = "WECHAT_WEAPP"),
        @JsonSubTypes.Type(value = BytedanceByteappSNSToken.class, name = "BYTEDANCE_BYTEAPP"),
})
@Getter
@Setter
public abstract class SNSToken implements TokenNamed {
    private static final String NAME = "SNSToken";

    private SNSTokenType type;

    private Instant expireAt;

    protected SNSToken(SNSTokenType type) {
        this.type = type;
    }


    @Override
    public String name() {
        return NAME;
    }
}
