package org.beast.security.core;

import lombok.Getter;
import lombok.Setter;
import org.beast.security.core.exception.TokenExpiredException;

import java.time.Instant;

@Getter @Setter
public class MobileToken implements TokenNamed {
    private static final String NAME = "MobileToken";

    private VerifyMode verifyMode;

    private String mobile;

    private Instant expiresAt;

    private Instant issuedAt;

    @Override
    public String name() {
        return NAME;
    }


    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }


    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        };
    }

    public enum VerifyMode {
        //短信 & 语音 代码验证
        CODE,
        //短信上行
        SMS_UPLINK,
        //微信小程序，授权
        WEAPP
    }
}
