/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import java.time.Instant;
import org.beast.security.core.TokenNamed;
import org.beast.security.core.exception.TokenExpiredException;

public class MobileToken
implements TokenNamed {
    private static final String NAME = "MobileToken";
    private VerifyMode verifyMode;
    private String mobile;
    private Instant expiresAt;
    private Instant issuedAt;

    @Override
    public String name() {
        return NAME;
    }

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        }
    }

    public VerifyMode getVerifyMode() {
        return this.verifyMode;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public void setVerifyMode(VerifyMode verifyMode) {
        this.verifyMode = verifyMode;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public static enum VerifyMode {
        CODE,
        SMS_UPLINK,
        WEAPP;

    }
}

