/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core;

import java.time.Instant;

public class AppOnceToken {
    private String appId;
    private String nonce;
    private Instant issuedAt;

    public AppOnceToken() {
    }

    public AppOnceToken(String appId, String nonce, Instant issuedAt) {
        this.appId = appId;
        this.nonce = nonce;
        this.issuedAt = issuedAt;
    }

    public boolean isExpireAt(int seconds) {
        Instant validity = this.issuedAt.plusSeconds(seconds);
        return Instant.now().isBefore(validity);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getNonce() {
        return this.nonce;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }
}

