/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.codec;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;
import org.beast.security.core.UserToken;
import org.beast.security.core.codec.AbstractJWTTokenBuilder;
import org.beast.security.core.codec.AbstractJWTTokenParser;
import org.beast.security.core.codec.TokenCodec;
import org.beast.security.core.util.KeySpecUtils;

public class UserTokenCodec
implements TokenCodec<UserToken> {
    public static final String PRI_RESOURCE = "classpath:token/xy-token-private.der";
    public static final String PUB_RESOURCE = "classpath:token/xy-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    @Override
    public String encode(UserToken token) {
        return TokenBuilder.getInstance().compact(token);
    }

    @Override
    public UserToken decode(String tokenString) {
        return (UserToken)TokenParser.getInstance().parse(tokenString);
    }

    public static class TokenBuilder
    extends AbstractJWTTokenBuilder<UserToken> {
        private static final TokenBuilder INSTANCE = new TokenBuilder();

        public TokenBuilder() {
            this(KeySpecUtils.readPrivateKey(UserTokenCodec.PRI_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public TokenBuilder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, UserToken token) {
            claims.put("app", token.getAppId());
            claims.put("uid", token.getUid());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }

        public static TokenBuilder getInstance() {
            return INSTANCE;
        }
    }

    public static class TokenParser
    extends AbstractJWTTokenParser<UserToken> {
        private static final TokenParser INSTANCE = new TokenParser();

        public TokenParser() {
            this(KeySpecUtils.readPublicKey(UserTokenCodec.PUB_RESOURCE));
        }

        public TokenParser(Key key) {
            super(key);
        }

        @Override
        protected UserToken read(Claims claims) {
            UserToken token = new UserToken();
            String appId = (String)claims.get("app", String.class);
            Long uid = (Long)claims.get("uid", Long.class);
            Instant issuedAt = Instant.ofEpochMilli((Long)claims.get("iss", Long.class));
            Instant expiresAt = Instant.ofEpochMilli((Long)claims.get("exp", Long.class));
            token.setAppId(appId);
            token.setUid(uid);
            token.setIssuedAt(issuedAt);
            token.setExpiresAt(expiresAt);
            return token;
        }

        public static TokenParser getInstance() {
            return INSTANCE;
        }
    }

    private static final class CLAIM_NAMES {
        public static final String APP = "app";
        public static final String UID = "uid";
        public static final String ISSUED_AT = "iss";
        public static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

