/*
 * Decompiled with CFR 0.152.
 */
package org.beast.security.core.codec;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;
import org.beast.security.core.MobileToken;
import org.beast.security.core.codec.AbstractJWTTokenBuilder;
import org.beast.security.core.codec.AbstractJWTTokenParser;
import org.beast.security.core.codec.TokenCodec;
import org.beast.security.core.util.KeySpecUtils;

public class MobileTokenCodec
implements TokenCodec<MobileToken> {
    private static final String PRI_RESOURCE = "classpath:token/mobile-token-private.der";
    private static final String PUB_RESOURCE = "classpath:token/mobile-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    @Override
    public String encode(MobileToken token) {
        return TokenBuilder.getInstance().compact(token);
    }

    @Override
    public MobileToken decode(String tokenString) {
        return (MobileToken)TokenParser.getInstance().parse(tokenString);
    }

    public static class TokenBuilder
    extends AbstractJWTTokenBuilder<MobileToken> {
        private static final TokenBuilder INSTANCE = new TokenBuilder();

        public TokenBuilder() {
            this(KeySpecUtils.readPrivateKey(MobileTokenCodec.PRI_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public TokenBuilder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, MobileToken token) {
            claims.put("verify-mode", (Object)token.getVerifyMode());
            claims.put("mobile", token.getMobile());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }

        public static TokenBuilder getInstance() {
            return INSTANCE;
        }
    }

    public static class TokenParser
    extends AbstractJWTTokenParser<MobileToken> {
        private static final TokenParser INSTANCE = new TokenParser();

        public TokenParser() {
            this(KeySpecUtils.readPublicKey(MobileTokenCodec.PUB_RESOURCE));
        }

        public TokenParser(Key key) {
            super(key);
        }

        @Override
        protected MobileToken read(Claims claims) {
            MobileToken token = new MobileToken();
            String verifyModeString = (String)claims.get("verify-mode", String.class);
            token.setVerifyMode(MobileToken.VerifyMode.valueOf(verifyModeString));
            token.setMobile((String)claims.get("mobile", String.class));
            token.setIssuedAt(Instant.ofEpochMilli((Long)claims.get("iss", Long.class)));
            token.setExpiresAt(Instant.ofEpochMilli((Long)claims.get("exp", Long.class)));
            token.verify();
            return token;
        }

        public static TokenParser getInstance() {
            return INSTANCE;
        }
    }

    private static final class CLAIM_NAMES {
        private static final String VERIFY_MODE = "verify-mode";
        private static final String MOBILE = "mobile";
        private static final String ISSUED_AT = "iss";
        private static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

