package org.beast.route.predicate;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.function.Predicate;

public class BetweenPredicateFactory extends AbstractPredicateFactory<BetweenPredicateFactory.Config>{

    private static DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        Instant beginAt = config.beginAt;
        Instant endAt = config.endAt;
        Assert.isTrue(beginAt.isBefore(endAt), FORMATTER.format(beginAt) + " must be before " + FORMATTER.format(endAt));
        return new Predicate<ServerWebExchange>() {
            @Override
            public boolean test(ServerWebExchange exchange) {
                final Instant now = Instant.now();
                return now.isAfter(beginAt) && now.isBefore(endAt);
            }
        };
    }

    @Getter
    @Setter
    public static class Config {

        private Instant beginAt;

        private Instant endAt;
    }
}
