package org.beast.route.predicate;

import org.beast.data.config.ShortcutConfigurable;
import org.beast.data.config.ShortcutField;
import org.beast.data.config.ShortcutFieldResolver;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class AbstractPredicateFactory<C> implements ShortcutConfigurable, PredicateFactory<C> {

    private Class<C> configClass;

    private static final ShortcutFieldResolver shortcutFieldResolver = new ShortcutFieldResolver();

    public AbstractPredicateFactory() {
        this(null);
    }

    public AbstractPredicateFactory(Class<C> clazz) {
        if (clazz == null) {
            Class<?> factoryClass = this.getClass();
            List<TypeInformation<?>> arguments = ClassTypeInformation.from(factoryClass)
                    .getRequiredSuperTypeInformation(AbstractPredicateFactory.class)
                    .getTypeArguments();
            clazz = (Class<C>) resolveTypeParameter(arguments, 0,
                    () -> String.format("Could not resolve config type of %s!", factoryClass));
        }
        this.configClass = clazz;
    }
    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index,
                                                 Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    @Override
    public List<ShortcutField> shortcutFields() {
        PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(this.configClass);
        List<ShortcutField> fields = new ArrayList<>();
        for (PropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            Class<?> clazz = descriptor.getPropertyType();
            ShortcutField field = shortcutFieldResolver.resolve(name, clazz);
            fields.add(field);
        }
        return fields;
    }

    @Override
    public Class<C> getConfigClass() {
        return configClass;
    }

    @Override
    public C newConfig() {
        return BeanUtils.instantiateClass(this.configClass);
    }

}
