/*
 * Decompiled with CFR 0.152.
 */
package org.beast.route.predicate;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.beast.data.config.ShortcutConfigurable;
import org.beast.data.config.ShortcutField;
import org.beast.data.config.ShortcutFieldResolver;
import org.beast.route.predicate.PredicateFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public abstract class AbstractPredicateFactory<C>
implements ShortcutConfigurable,
PredicateFactory<C> {
    private Class<C> configClass;
    private static final ShortcutFieldResolver shortcutFieldResolver = new ShortcutFieldResolver();

    public AbstractPredicateFactory() {
        this(null);
    }

    public AbstractPredicateFactory(Class<C> clazz) {
        if (clazz == null) {
            Class<?> factoryClass = this.getClass();
            List arguments = ClassTypeInformation.from(factoryClass).getRequiredSuperTypeInformation(AbstractPredicateFactory.class).getTypeArguments();
            clazz = AbstractPredicateFactory.resolveTypeParameter(arguments, 0, () -> String.format("Could not resolve config type of %s!", factoryClass));
        }
        this.configClass = clazz;
    }

    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    public List<ShortcutField> shortcutFields() {
        PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(this.configClass);
        ArrayList<ShortcutField> fields = new ArrayList<ShortcutField>();
        for (PropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            Class<?> clazz = descriptor.getPropertyType();
            ShortcutField field = shortcutFieldResolver.resolve(name, clazz);
            fields.add(field);
        }
        return fields;
    }

    @Override
    public Class<C> getConfigClass() {
        return this.configClass;
    }

    @Override
    public C newConfig() {
        return (C)BeanUtils.instantiateClass(this.configClass);
    }
}

