package org.beast.route.predicate;

import org.springframework.web.server.ServerWebExchange;

import java.util.function.Predicate;

public interface PredicateFactory<C> {

    default Class<C> getConfigClass() { throw new UnsupportedOperationException("getConfigClass() not implemented"); }

    default C newConfig() { throw new UnsupportedOperationException("newConfig() not implemented"); }

    Predicate<ServerWebExchange> apply(C config);

    default String name() {return getClass().getSimpleName().replace(PredicateFactory.class.getSimpleName(), "");}
}
