package org.beast.risk.engine.configuration;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.TaskScheduler;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;

@Slf4j
public class RiskPolicyWatch implements ApplicationEventPublisherAware, SmartLifecycle {

    private final TaskScheduler taskScheduler;

    private final AtomicBoolean running = new AtomicBoolean(false);

//    private final RiskDataSource dataSource;

    private final RiskConfigService configService;

    private ApplicationEventPublisher publisher;

    private ScheduledFuture<?> watchFuture;

    public RiskPolicyWatch(RiskConfigService configService, TaskScheduler taskScheduler) {
        this.configService = configService;
        this.taskScheduler = taskScheduler;
    }


    @Override
    public boolean isAutoStartup() {
        return true;
    }


    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {

    }

    @Override
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::configWatch,
                    5000);
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    @Override
    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public int getPhase() {
        return 0;
    }

//    @Timed("consul.watch-catalog-services")
    public void configWatch() {
        try {

            configService.refresh();
        } catch (Exception e) {
            log.error("Error watching RiskPolicy Watch Services", e);
        }
    }
}
