package org.beast.risk.engine.configuration;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import java.io.Reader;
import java.io.StringReader;

public class ConsulRiskPolicyDataSource implements RiskDataSource {
    private JAXBContext jc;
    private ConsulClient client;
    private String key;

    public ConsulRiskPolicyDataSource(ConsulClient client, String key) {
        try {
            this.jc = JAXBContext.newInstance(new Class[]{RiskProperties.class});
        } catch (JAXBException var4) {
            var4.printStackTrace();
        }

        this.client = client;
        this.key = key;
    }

    public RiskProperties readProperties() throws JAXBException {
        GetValue getValue = this.client.getKVValue(this.key).getValue();
        if (getValue == null) {
            throw new IllegalStateException("consul key:" + this.key + " is not exist");
        } else {
            Reader reader = new StringReader(getValue.getDecodedValue());
            return (RiskProperties)this.jc.createUnmarshaller().unmarshal(reader);
        }
    }
}
