package org.beast.risk.engine.configuration;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import java.net.URL;

public class ClassPathRiskPolicyDataSource implements RiskDataSource {
    private JAXBContext jc;
    private String path;

    public ClassPathRiskPolicyDataSource(String path)  {
        try {
            this.jc =  JAXBContext.newInstance(RiskProperties.class);
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        this.path = path;
    }

    @Override
    public RiskProperties readProperties() throws Exception {
        URL url = ClassPathRiskPolicyDataSource.class.getClassLoader().getResource(this.path);

        return (RiskProperties) jc.createUnmarshaller().unmarshal(url);
    }
}
