package org.beast.risk.engine;

import org.beast.risk.engine.configuration.RiskConfigRefreshListener;
import org.beast.risk.engine.configuration.RiskConfigService;
import org.beast.risk.engine.configuration.RiskDataSource;
import org.beast.risk.engine.configuration.RiskPolicyWatch;
import org.beast.risk.instrument.meter.MeterRegistry;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration(proxyBeanMethods = false)
@ConditionalOnBean({RiskDataSource.class})
public class RiskAutoConfiguration {

    public static final String WATCH_TASK_SCHEDULER_NAME = "riskWatchTaskScheduler";

    @Bean
    @ConditionalOnMissingBean
    public RiskRadar riskRadar() {
        return new RiskRadar();
    }

    @Bean
    @ConditionalOnMissingBean
    public MeterRegistry meterRegistry() {
        return new MeterRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public RiskConfigService task(RiskRadar radar, RiskDataSource dataSource) {
        return new RiskConfigService(radar, dataSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public RiskConfigRefreshListener refreshListener(RiskConfigService configService) {
        return new RiskConfigRefreshListener(configService);
    }

    @Bean
    @ConditionalOnMissingBean
    public RiskPolicyWatch riskPolicyWatch(RiskConfigService configService, @Qualifier(WATCH_TASK_SCHEDULER_NAME) TaskScheduler taskScheduler) {
        return new RiskPolicyWatch(configService, taskScheduler);
    }

    @Bean(name = WATCH_TASK_SCHEDULER_NAME)
    public TaskScheduler riskWatchTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }
}
