package org.beast.risk.engine.policy;

import lombok.Data;
import org.beast.risk.engine.IEvent;
import org.beast.risk.engine.RiskScanner;

@Data
public class EventHandler {

    private String name;

    private RiskScanner scanner;

    public boolean mapping(IEvent event) {
        var name = event.name();
        if (!"*".equals(this.name) && !this.name.equals(name)) {
            return false;
        }
        return true;
    }

    public void scan(IEvent event) {
        scanner.scan(event);
    }
}
