package org.beast.risk.engine.configuration;

import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;
import java.util.Map;

@XmlRootElement(name = "risk")
@Getter
@Setter
public class RiskProperties {

    private List<Intent> intent;

    private List<Event> event;

    @Override
    public String toString() {
        return "RiskProperties{" +
                '}';
    }

    @Getter
    @Setter
    public static class Event {

        private String name;

        private Scanner scanner;

        @XmlAttribute(name = "name")
        public void setName(String name) {
            this.name = name;
        }
    }

    @Getter
    @Setter
    public static class Scanner {
        private String clazz;

        private Map<String, String> initParams;

        @XmlElement(name = "class")
        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        @XmlElement(name = "init-params")
        @XmlJavaTypeAdapter(MapAdapter.class)
        public void setInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
        }
    }

    @Getter
    @Setter
    public static class Intent {


        private String name;

        private Assertion assertion;

        @XmlAttribute(name = "name")
        public void setName(String name) {
            this.name = name;
        }
    }

    @Getter
    @Setter
    public static class Assertion {

        private String clazz;

        private Map<String, String> initParams;

        @XmlElement(name = "class")
        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        @XmlElement(name = "init-params")
        @XmlJavaTypeAdapter(MapAdapter.class)
        public void setInitParams(Map<String, String> initParams) {
            this.initParams = initParams;
        }
    }
}
