package org.beast.risk.engine;

import org.beast.risk.engine.configuration.RiskConfigService;
import org.beast.risk.engine.configuration.RiskDataSource;
import org.beast.risk.instrument.meter.MeterRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
@ConditionalOnBean({RiskDataSource.class})
public class RiskAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public RiskRadar riskRadar() {
        return new RiskRadar();
    }

    @Bean
    @ConditionalOnMissingBean
    public MeterRegistry meterRegistry() {
        return new MeterRegistry();
    }

    @Bean
    @ConditionalOnBean({RiskDataSource.class})
    @ConditionalOnMissingBean
    public RiskConfigService task(RiskDataSource dataSource) {
        return new RiskConfigService(dataSource);
    }
}
