package org.beast.risk.engine.redis;

import org.beast.risk.Instruments;
import org.beast.risk.engine.RiskAutoConfiguration;
import org.beast.risk.instrument.meter.MeterRegistry;
import org.beast.risk.instrument.meter.factory.RCounterFactory;
import org.beast.risk.instrument.meter.factory.RSetFactory;
import org.beast.risk.redis.factory.RedisRCounterFactory;
import org.beast.risk.redis.factory.RedisRSetFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration(proxyBeanMethods = false)
@AutoConfigureAfter(RiskAutoConfiguration.class)
public class RedisRiskAutoConfiguration {


    @Bean
    public RCounterFactory recentlyCounterFactory(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, Integer> template = new RedisTemplate<>();
        template.setKeySerializer(new StringRedisSerializer());
        template.setValueSerializer(new GenericToStringSerializer<Integer>(Integer.class));
        template.setConnectionFactory(redisConnectionFactory);
        template.afterPropertiesSet();
        return new RedisRCounterFactory(template);
    }

    @Bean
    public RSetFactory setFactory(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate<String, String> template = new RedisTemplate<>();
        template.setKeySerializer(new StringRedisSerializer());
        template.setValueSerializer(new StringRedisSerializer());
        template.setConnectionFactory(redisConnectionFactory);
        template.afterPropertiesSet();
        return new RedisRSetFactory(template);
    }

    @Bean
    public Instruments instruments(
            MeterRegistry registry
    ) {
        return new Instruments(registry);
    }
}
