package org.beast.risk.engine.policy;

import lombok.Data;
import org.beast.risk.engine.HitAssertion;
import org.beast.risk.engine.Intent;
import org.beast.risk.engine.RiskHit;

@Data
public class IntentHandler {

    private String name;

    private HitAssertion assertion;

    public boolean mapping(Intent intent) {
        var name = intent.getName();
        if (!"*".equals(this.name) && !this.name.equals(name)) {
            return false;
        }
        return true;
    }

    public RiskHit hit(Intent intent) {
        var hit = assertion.hit(intent);
        return RiskHit.builder().hit(hit).build();
    }

}
