package org.beast.risk.engine.policy;

import lombok.Data;
import org.beast.risk.engine.Event;
import org.beast.risk.engine.RiskScanner;

@Data
public class EventHandler {

    private String name;

    private RiskScanner scanner;

    public boolean mapping(Event event) {
        var name = event.getName();
        if (!"*".equals(this.name) && !this.name.equals(name)) {
            return false;
        }
        return true;
    }

    public void scan(Event event) {
        scanner.scan(event);
    }
}
