package org.beast.risk.engine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.beast.risk.engine.assertion.NoneHitAssertion;
import org.beast.risk.engine.policy.EventHandler;
import org.beast.risk.engine.policy.IntentHandler;

import java.util.List;
import java.util.Map;

public class RiskRadar {

    private static final NoneHitAssertion NONE = new NoneHitAssertion();
    private List<IntentHandler> handlers;
    private List<EventHandler> eventHandlers;



    public RiskHit hit(Intent intent) {
        for (IntentHandler intentHandler : handlers) {
            if (intentHandler.mapping(intent)) {
                var hit = intentHandler.hit(intent);
                if (hit.isHit()) {
                    return hit;
                }
            }
        }
        return RiskHit.pass();
    }

    public void scan(Event event) {
        for (EventHandler handler : eventHandlers) {
            if (handler.mapping(event)) {
                handler.scan(event);
            }
        }
    }

    public void configuration(List<IntentHandler> handlers, List<EventHandler> eventHandlers) {
        this.handlers = handlers;
        this.eventHandlers = eventHandlers;
    }
}
