/*
 * Decompiled with CFR 0.152.
 */
package org.beast.risk.data;

import java.time.Instant;
import org.beast.risk.data.AccessContext;
import org.beast.risk.data.Payload;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class EventInput {
    private String outId;
    private AccessContext context;
    @NonNull
    private String name;
    private Payload payload;
    @Nullable
    private Instant time;

    public EventInput() {
    }

    EventInput(String outId, AccessContext context, @NonNull String name, Payload payload, @Nullable Instant time) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.outId = outId;
        this.context = context;
        this.name = name;
        this.payload = payload;
        this.time = time;
    }

    public static EventInputBuilder builder() {
        return new EventInputBuilder();
    }

    public String getOutId() {
        return this.outId;
    }

    public AccessContext getContext() {
        return this.context;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Payload getPayload() {
        return this.payload;
    }

    @Nullable
    public Instant getTime() {
        return this.time;
    }

    public void setOutId(String outId) {
        this.outId = outId;
    }

    public void setContext(AccessContext context) {
        this.context = context;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public void setTime(@Nullable Instant time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventInput)) {
            return false;
        }
        EventInput other = (EventInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$outId = this.getOutId();
        String other$outId = other.getOutId();
        if (this$outId == null ? other$outId != null : !this$outId.equals(other$outId)) {
            return false;
        }
        AccessContext this$context = this.getContext();
        AccessContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Payload this$payload = this.getPayload();
        Payload other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        Instant this$time = this.getTime();
        Instant other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $outId = this.getOutId();
        result = result * 59 + ($outId == null ? 43 : $outId.hashCode());
        AccessContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Payload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        Instant $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public String toString() {
        return "EventInput(outId=" + this.getOutId() + ", context=" + this.getContext() + ", name=" + this.getName() + ", payload=" + this.getPayload() + ", time=" + this.getTime() + ")";
    }

    public static class EventInputBuilder {
        private String outId;
        private AccessContext context;
        private String name;
        private Payload payload;
        private Instant time;

        EventInputBuilder() {
        }

        public EventInputBuilder outId(String outId) {
            this.outId = outId;
            return this;
        }

        public EventInputBuilder context(AccessContext context) {
            this.context = context;
            return this;
        }

        public EventInputBuilder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        public EventInputBuilder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public EventInputBuilder time(@Nullable Instant time) {
            this.time = time;
            return this;
        }

        public EventInput build() {
            return new EventInput(this.outId, this.context, this.name, this.payload, this.time);
        }

        public String toString() {
            return "EventInput.EventInputBuilder(outId=" + this.outId + ", context=" + this.context + ", name=" + this.name + ", payload=" + this.payload + ", time=" + this.time + ")";
        }
    }
}

