package org.beast.risk.instrument.meter;

import lombok.Getter;
import lombok.ToString;

import java.time.Duration;

public interface Meter {

    Id getId();

    enum Type {
        RECENTLY_COUNTER
    }

    @ToString
    @Getter
    class Id {

        private final Type type;

        private final Duration duration;

        private final String name;

        private final String tag;


        private final String description;

        public Id(Type type, Duration duration, String name, String tag, String description) {
            this.type = type;
            this.duration = duration;
            this.name = name;
            this.tag = tag;
            this.description = description;
        }

        public String getConventionName() {
            return name;
//            return namingConvention.name(name, type, baseUnit);
        }

    }

    default void close() {
    }
}
