package org.beast.risk.redis.factory;

import org.beast.risk.instrument.meter.Meter;
import org.beast.risk.instrument.meter.RSet;
import org.beast.risk.instrument.meter.factory.RSetFactory;
import org.beast.risk.redis.RedisRSet;
import org.springframework.data.redis.core.RedisTemplate;

import java.time.Duration;

public class RedisRSetFactory implements RSetFactory {


    private RedisTemplate<String, String> template;

    public RedisRSetFactory(RedisTemplate<String, String> template) {
        this.template = template;
    }

    @Override
    public RSet create(Meter.Id id) {
        return new RedisRSet(id, template);
    }
}
