package org.beast.risk.redis;

import org.beast.risk.instrument.meter.AbstractMeter;
import org.beast.risk.instrument.meter.RSet;
import org.springframework.data.redis.core.RedisTemplate;

import java.time.Duration;
import java.util.Objects;

public class RedisRSet extends AbstractMeter implements RSet, RedisMeter {


    private RedisTemplate<String, String> template;


    public RedisRSet(Id id, RedisTemplate<String, String> template) {
        super(id);
        this.template = template;
    }

    @Override
    public void add(String value) {
        var id = this.getId();
        var key = this.getConventionName();
        var hasKey = Objects.requireNonNull(template.hasKey(key));
        template.opsForSet().add(key, value);
        if (!hasKey) {
            template.expire(key, id.getDuration());
        }
    }

    @Override
    public int size() {
        var key = this.getConventionName();
        return Math.toIntExact(Objects.requireNonNull(template.opsForSet().size(key)));
    }
}
