package org.beast.risk.redis;

import org.beast.risk.instrument.meter.AbstractMeter;
import org.beast.risk.instrument.meter.RCounter;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.Objects;

public class RedisRCounter extends AbstractMeter implements RCounter, RedisMeter {

    private RedisTemplate<String, Integer> template;


    public RedisRCounter(Id id, RedisTemplate<String, Integer> template) {
        super(id);
        this.template = template;
    }


    @Override
    public int increment(int delta) {
        var key = this.getConventionName();
        var hasKey = Objects.requireNonNull(template.hasKey(key));
        long value = Objects.requireNonNull(template.opsForValue().increment(key, delta));
        if (!hasKey) {
            template.expire(key, this.getId().getDuration());
        }

        return Math.toIntExact(value);
    }

    @Override
    public int count() {
        var value = template.opsForValue().get(this.getConventionName());
        if (Objects.isNull(value)) {
            return 0;
        }
        return value;
    }
}
