package org.beast.risk.redis.factory;

import org.beast.risk.instrument.meter.Meter;
import org.beast.risk.instrument.meter.RCounter;
import org.beast.risk.instrument.meter.factory.RCounterFactory;
import org.beast.risk.redis.RedisRCounter;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisRCounterFactory implements RCounterFactory {

    private RedisTemplate<String, Integer> template;

    public RedisRCounterFactory(RedisTemplate<String, Integer> template) {
        this.template = template;
    }

    @Override
    public RCounter create(Meter.Id id) {
        return new RedisRCounter(id, template);
    }
}
