package org.beast.risk;

import org.beast.risk.instrument.meter.Meter;
import org.beast.risk.instrument.meter.MeterRegistry;
import org.beast.risk.instrument.meter.RCounter;
import org.beast.risk.instrument.meter.RSet;
import org.beast.risk.instrument.meter.factory.RCounterFactory;
import org.beast.risk.instrument.meter.factory.RSetFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.Duration;

public class Instruments {

    private MeterRegistry registry;
    private RCounterFactory counterFactory;
    private RSetFactory setFactory;

    public Instruments(
            MeterRegistry registry
    ) {
        this.registry = registry;
    }

    @Autowired
    public void setCounterFactory(RCounterFactory counterFactory) {
        this.counterFactory = counterFactory;
    }

    @Autowired
    public void setSetFactory(RSetFactory setFactory) {
        this.setFactory = setFactory;
    }

    public RCounter counter(Duration duration, String name, String tag) {
        var meterId = new Meter.Id(Meter.Type.RECENTLY_COUNTER, duration, name, tag, null);
        return registry.registerMeterIfNecessary(RCounter.class, meterId, (id) -> {
            return counterFactory.create(id);
        });
    }

    public RSet set(Duration duration, String name, String tag) {
        var meterId = new Meter.Id(Meter.Type.RECENTLY_COUNTER, duration, name, tag, null);
        return registry.registerMeterIfNecessary(RSet.class, meterId, (id) -> {
            return setFactory.create(id);
        });
    }


}
