package org.beast.propagation.instrument.web.client.feign;

import org.beast.propagation.Propagation;
import org.beast.propagation.context.CurrentContext;
import feign.Client;
import feign.Request;
import feign.Response;
import org.springframework.beans.factory.BeanFactory;

import java.io.IOException;

public class LazyPropagationFeignClient implements Client {

    private final BeanFactory beanFactory;

    private final Client delegate;

    private PropagationFeignClient propagationFeignClient;

    public LazyPropagationFeignClient(BeanFactory beanFactory, Client delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }


    @Override
    public Response execute(Request request, Request.Options options) throws IOException {
        return this.injectorFeignClient().execute(request, options);
    }

    private Client injectorFeignClient() {
        if (this.propagationFeignClient == null) {
            CurrentContext currentContext = this.beanFactory.getBean(CurrentContext.class);
            Propagation propagation = this.beanFactory.getBean(Propagation.class);
            this.propagationFeignClient = new PropagationFeignClient(
                    currentContext, propagation, this.delegate
            );
        }
        return this.propagationFeignClient;
    }
}
