package org.beast.propagation.instrument.reactor;

import org.reactivestreams.Subscription;
import reactor.util.context.Context;

import java.util.function.Supplier;

public class LazyPassingSubscriber<T> implements PassingSubscription<T> {
    private final Supplier<PassingSubscription<T>> supplier;

    LazyPassingSubscriber(Supplier<PassingSubscription<T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        this.supplier.get().onSubscribe(subscription);
    }

    @Override
    public void request(long n) {
        this.supplier.get().request(n);
    }

    @Override
    public void cancel() {
        this.supplier.get().cancel();
    }

    @Override
    public void onNext(T o) {
        this.supplier.get().onNext(o);
    }

    @Override
    public void onError(Throwable throwable) {
        this.supplier.get().onError(throwable);
    }

    @Override
    public void onComplete() {
        this.supplier.get().onComplete();
    }

    @Override
    public Context currentContext() {
        return this.supplier.get().currentContext();
    }
}
