package org.beast.propagation.instrument.async;

import org.beast.propagation.context.Context;
import org.beast.propagation.context.CurrentContext;

public class ContextRunnable implements Runnable {

    private CurrentContext currentContext;
    private Context context;
    private Runnable delegate;

    public ContextRunnable(CurrentContext currentContext, Runnable runnable) {
        this.currentContext = currentContext;
        this.context = currentContext.get();
        this.delegate = runnable;
    }

    @Override
    public void run() {
        try (CurrentContext.Scope scope = this.currentContext.maybeScope(this.context)) {
            delegate.run();
        }
    }
}
