package org.beast.propagation;

import lombok.extern.slf4j.Slf4j;
import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.context.ThreadLocalCurrentContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Slf4j
@Configuration(proxyBeanMethods = false)
//@EnableConfigurationProperties
public class PropagationAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public CurrentContext currentContext() {
        return ThreadLocalCurrentContext.create();
    }

    @Bean
    @ConditionalOnMissingBean
    public Propagation propagation() {
        return new DefaultPropagation(List.of("X-Sequences"));
    }

}
