package org.beast.propagation.instrument.reactor;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import reactor.core.publisher.Hooks;

public class HookRegisteringBeanDefinitionRegistryPostProcessor implements BeanDefinitionRegistryPostProcessor {

    private static final String PROPAGATION_REACTOR_EXECUTOR_SERVICE_KEY = "propagation";




    HookRegisteringBeanDefinitionRegistryPostProcessor() {

    }

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {

    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        setupHooks(beanFactory);
    }

    void setupHooks(BeanFactory beanFactory) {
//        ConfigurableEnvironment environment = this.context.getEnvironment();
//        boolean decorateOnEach = environment.getProperty(
//                "spring.sleuth.reactor.decorate-on-each", Boolean.class, true);
//        if (decorateOnEach) {
//            if (log.isTraceEnabled()) {
//                log.trace("Decorating onEach operator instrumentation");
//            }
//            Hooks.onEachOperator(SLEUTH_TRACE_REACTOR_KEY,
//                    ReactorSleuth.scopePassingSpanOperator(this.context));
//        }
//        else {
//            if (log.isTraceEnabled()) {
//                log.trace("Decorating onLast operator instrumentation");
//            }
//            Hooks.onLastOperator(SLEUTH_TRACE_REACTOR_KEY,
//                    ReactorSleuth.scopePassingSpanOperator(this.context));
//        }
//        Schedulers.setExecutorServiceDecorator(
//                PROPAGATION_REACTOR_EXECUTOR_SERVICE_KEY,
//                (scheduler,
//                 scheduledExecutorService) -> new TraceableScheduledExecutorService(
//                        beanFactory, scheduledExecutorService));

        Hooks.onEachOperator(PROPAGATION_REACTOR_EXECUTOR_SERVICE_KEY,
                Reactors.scopePassingSpanOperator(beanFactory));
    }
}
