/*
 * Decompiled with CFR 0.152.
 */
package org.beast.propagation.instrument.async;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.beast.propagation.context.CurrentContext;
import org.beast.propagation.instrument.async.ContextExecutor;
import org.springframework.util.ReflectionUtils;

public class ExecutorMethodInterceptor<T extends Executor>
implements MethodInterceptor {
    private final T delegate;
    private final CurrentContext currentContext;

    ExecutorMethodInterceptor(T delegate, CurrentContext currentContext) {
        this.delegate = delegate;
        this.currentContext = currentContext;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        T executor = this.executor(this.currentContext, this.delegate);
        Method methodOnTracedBean = this.getMethod(invocation, executor);
        if (methodOnTracedBean != null) {
            try {
                return methodOnTracedBean.invoke(executor, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                throw cause != null ? cause : ex;
            }
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }

    T executor(CurrentContext currentContext, T executor) {
        return (T)new ContextExecutor(currentContext, (Executor)executor);
    }
}

