package org.beast.propagation.instrument.web.client.feign;


import org.beast.propagation.Propagation;
import feign.Client;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = false)
@ConditionalOnClass({ Client.class, FeignContext.class })
@ConditionalOnBean(Propagation.class)
@AutoConfigureBefore(FeignAutoConfiguration.class)
public class PropagationFeignClientAutoConfiguration {


    @Configuration(proxyBeanMethods = false)
    protected static class FeignDelegateBeanPostProcessorConfiguration {

        @Bean
        static FeignContextDelegateBeanPostProcessor feignContextDelegateBeanPostProcessor(
                BeanFactory beanFactory) {
            return new FeignContextDelegateBeanPostProcessor(beanFactory);
        }
    }
}
