package org.beast.propagation.instrument.web.client.feign;

import org.springframework.cloud.openfeign.FeignContext;

import java.util.HashMap;
import java.util.Map;

public class FeignContextWrapper extends FeignContext {

    private final PropagationFeignObjectWrapper propagationFeignObjectWrapper;

    private final FeignContext delegate;


    public FeignContextWrapper(PropagationFeignObjectWrapper propagationFeignObjectWrapper, FeignContext delegate) {
        this.propagationFeignObjectWrapper = propagationFeignObjectWrapper;
        this.delegate = delegate;
    }


    @Override
    public <T> T getInstance(String name, Class<T> type) {
        T object = this.delegate.getInstance(name, type);
        return (T) this.propagationFeignObjectWrapper.wrap(object);
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map<String, T> instances = this.delegate.getInstances(name, type);
        if (instances == null) {
            return null;
        }
        Map<String, T> convertedInstances = new HashMap<>();
        for (Map.Entry<String, T> entry : instances.entrySet()) {
            convertedInstances.put(entry.getKey(),
                    (T) this.propagationFeignObjectWrapper.wrap(entry.getValue()));
        }
        return convertedInstances;
    }
}
