package org.beast.propagation.instrument.async;

import org.beast.propagation.context.CurrentContext;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;

public class ExecutorMethodInterceptor<T extends Executor> implements MethodInterceptor {
    private final T delegate;

    private final CurrentContext currentContext;

    ExecutorMethodInterceptor(T delegate, CurrentContext currentContext) {
        this.delegate = delegate;
        this.currentContext = currentContext;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        T executor = executor(this.currentContext, this.delegate);
        Method methodOnTracedBean = getMethod(invocation, executor);
        if (methodOnTracedBean != null) {
            try {
                return methodOnTracedBean.invoke(executor, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                // gh-1092: throw the target exception (if present)
                Throwable cause = ex.getCause();
                throw (cause != null) ? cause : ex;
            }
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), method.getName(),
                method.getParameterTypes());
    }

    T executor(CurrentContext currentContext, T executor) {
        return (T) new ContextExecutor(currentContext, executor);
    }
}
