package org.beast.propagation;

import org.beast.propagation.context.Context;

import java.util.List;

public class DefaultPropagation implements Propagation{


    private final List<String> keys;

    public DefaultPropagation(List<String> keys) {
        this.keys = keys;
    }

    @Override
    public List<String> keys() {
        return this.keys;
    }

    @Override
    public <C> Context.Injector<C> injector(Setter<C> setter) {
        return new InnerInjector<>(this, setter);
    }

    @Override
    public <C> Context.Extractor<C> extractor(Getter<C> getter) {
        return new InnerExtractor<>(this, getter);
    }


    static final class InnerInjector<C> implements Context.Injector<C> {

        private Propagation propagation;
        private Setter<C> setter;

        public InnerInjector(Propagation propagation, Setter<C> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        @Override
        public <T> void inject(Context context, C carrier) {
            if (context != null) {
                for (String key : propagation.keys()) {
                    setter.put(carrier, key, context.get(key));
                }
            }
        }
    }

    static final class InnerExtractor<C> implements Context.Extractor<C> {
        private Propagation propagation;
        private Getter<C> getter;

        public InnerExtractor(Propagation propagation, Getter<C> getter) {
            this.propagation = propagation;
            this.getter = getter;
        }

        @Override
        public Context extract(C carrier) {
            Context context = new Context();
            for (String key : propagation.keys()) {
                context.put(key, getter.get(carrier, key));
            }
            return context;
        }
    }


}
